#if defined(WAVE)
attribute vec2 coord_xz;
attribute float coord_y;
#else
attribute vec3 coord1;
#endif

uniform mat4 mvp;
uniform float flow;

#if defined(SHORE)
attribute vec3 coord2;
attribute vec2 alpha;
uniform float interpol;
#elif defined(SEA)
attribute float alpha;
	#if defined(SEA_NICE)
	attribute vec3 coord2;
	attribute float period_index;
	#endif
#elif defined(WAVE)
uniform float interpol;
#endif

varying vec2 f_texcoord;
varying vec4 f_colorLight;
varying float f_alpha;

#ifdef WAVE
varying float f_posZ;
#endif

#if defined(FOG) || defined(WAVE)
uniform mat4 m;
#endif

#ifdef FOG
uniform mat4 v;
varying float f_fogFactor;
#endif

#if defined(SEA)
varying float f_seaBorder;
#endif

#if defined(SEA_NICE)
uniform vec4 period_factors;
#endif


void main(void)
{
	#if defined(SEA_NICE)
	int periodIndex = int(period_index);
	float periodInterpol = period_factors[periodIndex];
	#endif

	//Position
	#if defined(SHORE)
	vec3 coord = mix(coord1, coord2, interpol);
	#elif defined(SEA_NICE)
	vec3 coord = coord1;
	coord.y = mix(coord.y, coord2.y, periodInterpol);
	#elif defined(WAVE)
	vec3 coord = vec3(coord_xz.x, coord_y, coord_xz.y);
	coord.y *= interpol;
	#else
	vec3 coord = coord1;
	#endif
	gl_Position = mvp * vec4(coord, 1.0);

	#ifdef WAVE
	vec4 positionWorld =  m * vec4(coord, 1.0);
	f_posZ = positionWorld.z;
	#endif

	//Lighting
	vec3 ambientLighting = getAmbientLighting(currentLight.ambient, currentMaterial.ambient);
	#if defined(SEA_NICE)
	const float lightMult = 0.3;
	float lightFactor = mix(coord2.x, coord2.z, periodInterpol);
	ambientLighting *= 1.0+lightMult*lightFactor;
	#endif
	f_colorLight = vec4(ambientLighting, 1.0);

	#if defined(SHORE)
	f_alpha = mix(alpha.x, alpha.y, interpol);
	#elif defined(WAVE)
	f_alpha = 1.0;
		#ifdef WATER_SHADER_ALPHA
		f_alpha = WATER_SHADER_ALPHA_VALUE;
		#endif
	f_alpha *= interpol;
	#else
	f_alpha = 1.0;
	#endif

	f_texcoord = TEX_COORD_SCALE*vec2(coord.x, coord.z);
	f_texcoord.y += flow;

	#ifdef SEA
	f_seaBorder = alpha;
	#endif

#ifdef FOG
	#ifndef WAVE
	vec4 positionWorld = m * vec4(coord, 1.0);
	#endif
	f_fogFactor = getFogFactor(v, positionWorld);
#endif
}
